%%%%%%%%% TYPE 1 SINGULARITY LOCI OF ORIENTATIONAL PARALLEL MECHANISMS %%%%%%%%
%
% This program is called by SingLociType1.m
%
% Last modified on June 16, 2005
% Written by Ilian A. Bonev
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%TWO BIG LOOPS FOR ALPHA
 for I = 1:2,
  if I == 1, alpha = alpha_min; else alpha = alpha_max; end
 
  %initialize the maximum five segments of each curve (unfortunately, by
  %sweeping phi from 0 to 2*pi, we follow the curve by jumping from one segment
  %to another, a maximum of five times)
  for i = 1:9,
    X{i} = []; Y{i} = [];
  end
  segment = 1;

  theta = []; phi = [];
  
  %CALCULATE THE SINGULARITY LOCI BY SEGMENTS
  if (alpha == 0) | (alpha == pi), %Case 1: Loci are points or curves
    if (beta1 == beta2),
      if (alpha == 0) & (sigma == 0),
        phi = [0:0.001:0.9999999*pi/2,NaN,1.0000001*pi/2:0.001:pi];
        theta = 2*atan(cos(beta1)./(sin(beta1)*cos(phi)));
      elseif (alpha == pi),
        phi = sigma/2;
        theta = -2*atan(sin(beta1)*cos(phi)/cos(beta1));
      end
    else
      if (cos(sigma)*sin(beta2)-cos(alpha)*sin(beta1) ~= 0),
        phi = atan(sin(sigma)*sin(beta2)/...
                   (cos(sigma)*sin(beta2)-cos(alpha)*sin(beta1)));
      else
        phi = pi;
      end
      q2 = -cos(sigma-2*phi)*sin(beta1)*sin(beta2) + cos(beta1)*cos(beta2)- ...
           cos(alpha);
      q1 = cos(sigma-phi)*cos(beta1)*sin(beta2) + ...
           cos(phi)*sin(beta1)*cos(beta2);
      if (q2 ~= 0),
        theta = 2*atan(-q1/q2);
      elseif (q1 == 0)
        theta = 0:2*pi/100:2*pi;
      end
    end
    X{1} = theta.*cos(phi);
    Y{1} = theta.*sin(phi);
  else %Case 2: Loci are curves
    for phi = 0:2*pi/1000:2*pi,
      q2 = -cos(sigma-2*phi)*sin(beta1)*sin(beta2) + cos(beta1)*cos(beta2) - ...
           cos(alpha);
      q1 = cos(sigma-phi)*cos(beta1)*sin(beta2) + ...
           cos(phi)*sin(beta1)*cos(beta2);
      q0 = cos(sigma)*sin(beta1)*sin(beta2) - cos(beta1)*cos(beta2) - ...
           cos(alpha);
      if (q1^2 - q2*q0) > 0,
        if q2 ~= 0,
          theta = 2*atan((-q1+sqrt(q1^2-q2*q0))/q2);
        else
          if q1 ~= 0,
            theta = 2*atan(-q0/(2*q1));
          elseif q0 == 0,
            theta = 0:2*pi/100:2*pi;
          end
          %theta = pi is a solution but we will not plot it
        end
        Xt = theta*cos(phi);
        Yt = theta*sin(phi);
        if (length(X{segment}) > 1),
          %if the point that we have found is too far from the previous one,
          %then assign it to the next segment
          if (sqrt((X{segment}(end)-Xt(1))^2+(Y{segment}(end)-Yt(1))^2) > 0.2),
            segment = segment + 1;
          end
        end
        X{segment} = [X{segment},Xt];
        Y{segment} = [Y{segment},Yt];
      end
    end
  end
 
  %ASSEMBLE THE SEGMENTS INTO A SIGNLE POLYGON
  %starting with the first segments, stick to it the one that is closest to it
  %(i.e., one of its end points is closest to one of the end points of the
  %first segment), by reversing the order of the segment if necessary, etc.
  Xall{I} = X{1};
  Yall{I} = Y{1};
  D1 = ones(1,segment)*NaN; D2 = D1;
  other_segments = [2:segment];
  while ~isempty(other_segments),
    for i = other_segments,
      D1(i) = sqrt( (Xall{I}(end)-X{i}(1))^2 + (Yall{I}(end)-Y{i}(1))^2 );
      D2(i) = sqrt( (Xall{I}(end)-X{i}(end))^2 + (Yall{I}(end)-Y{i}(end))^2 );
    end
    [minD,indD]=min([D1,D2]);
    if minD < 0.3,
      if indD > segment,
        Xall{I} = [Xall{I}, X{indD-segment}(end:-1:1)];
        Yall{I} = [Yall{I}, Y{indD-segment}(end:-1:1)];
        indD = indD - segment;
      else
        Xall{I} = [Xall{I}, X{indD}];
        Yall{I} = [Yall{I}, Y{indD}];
      end
    else
      if indD > segment, indD = indD - segment; end
      Xall{I} = [Xall{I}, NaN, X{indD}];
      Yall{I} = [Yall{I}, NaN, Y{indD}];
    end
    D1 = ones(1,segment)*NaN; D2 = D1;
    other_segments = other_segments(find(other_segments~=indD));
  end
 end %end of big loop for alpha

%EXTRACT THE WORKSPACE BOUNDARIES
%Extract only the part of each curve that is inside the other two vertex spaces
 XallB{1} = []; YallB{1} = [];
 XallB{2} = []; YallB{2} = [];
 for I = 1:2,
   for i = 1:length(Xall{I}),
     theta = sqrt(Xall{I}(i)^2+Yall{I}(i)^2);
     phi = atan2(Yall{I}(i),Xall{I}(i));
     for j = 2:3,
       Phi = phi + (j-1)*2*pi/3;
       E(j) = (cos(Phi)*cos(sigma-Phi)*sin(beta1)*sin(beta2) ...
                - cos(beta1)*cos(beta2))*cos(theta) + ...
              (cos(sigma-Phi)*cos(beta1)*sin(beta2) + ...
                cos(Phi)*sin(beta1)*cos(beta2))*sin(theta) - ...
              sin(Phi)*sin(sigma-Phi)*sin(beta1)*sin(beta2);
     end
     if (E(2) <= cos(alpha_min)) & (E(2) >= cos(alpha_max)) & ...
        (E(3) <= cos(alpha_min)) & (E(3) >= cos(alpha_max)),
       XallB{I}(end+1) = Xall{I}(i); Xall{I}(i) = NaN;
       YallB{I}(end+1) = Yall{I}(i); Yall{I}(i) = NaN;
     else
       XallB{I}(end+1) = NaN;
       YallB{I}(end+1) = NaN;
     end
   end
   %join ends if they are very close
   if length(XallB{I})>2,
     if sqrt((XallB{I}(end)-XallB{I}(1))^2 + (YallB{I}(end)-YallB{I}(1))^2) < 0.3,
       XallB{I}(end+1) = XallB{I}(1);
       YallB{I}(end+1) = YallB{I}(1);
     end
   end
 end
 
%HATCH WORKSPACE REGION (a discretization procedure)
 if (hatch == 1),
   XHatchedWorkspace = []; YHatchedWorkspace = [];
   for phi = 0:pi/50:(2*pi-pi/50),
     for theta = 0:pi/37:(pi-pi/37),
       for j = 1:3,
         Phi = phi + (j-1)*2*pi/3;
         E(j) = (cos(Phi)*cos(sigma-Phi)*sin(beta1)*sin(beta2) ...
                  - cos(beta1)*cos(beta2))*cos(theta) + ...
                (cos(sigma-Phi)*cos(beta1)*sin(beta2) + ...
                  cos(Phi)*sin(beta1)*cos(beta2))*sin(theta) - ...
                sin(Phi)*sin(sigma-Phi)*sin(beta1)*sin(beta2);
       end       
       if (E(1) <= cos(alpha_min)) & (E(1) >= cos(alpha_max)) & ...
          (E(2) <= cos(alpha_min)) & (E(2) >= cos(alpha_max)) & ...
          (E(3) <= cos(alpha_min)) & (E(3) >= cos(alpha_max)),
         XHatchedWorkspace(end+1) = theta*cos(phi);
         YHatchedWorkspace(end+1) = theta*sin(phi);
       end
     end
   end
 end

%DRAW THE SINGULARITY CURVES, THE WORKSPACE BOUNDARIES, AND THE WORKSPACE HATCH
 %Draw the Type 1 singularity curves in gray color
 for i = 1:3,
   s(i) = sin((i-1)*2*pi/3); c(i) = cos((i-1)*2*pi/3);
   set(curve_iL(i),'xdata',Xall{1}*c(i) - Yall{1}*s(i),...
                   'ydata',Xall{1}*s(i) + Yall{1}*c(i));
   set(curve_iB(i),'xdata',XallB{1}*c(i) - YallB{1}*s(i),...
                   'ydata',XallB{1}*s(i) + YallB{1}*c(i));
   set(curve_eL(i),'xdata',Xall{2}*c(i) - Yall{2}*s(i),...
                   'ydata',Xall{2}*s(i) + Yall{2}*c(i));
   set(curve_eB(i),'xdata',XallB{2}*c(i) - YallB{2}*s(i),...
                   'ydata',XallB{2}*s(i) + YallB{2}*c(i));
 end
 
 %If the singularity loci have degenerated to points inside the workspace,
 %then draw them with special markers
 if length(XallB{1}) == 1,
   for i = 1:3,
     set(point_i(i),'xdata',XallB{1}*c(i) - YallB{1}*s(i),...
                    'ydata',XallB{1}*s(i) + YallB{1}*c(i));
   end
 else
   %otherwise get rid of the markers
   for i = 1:3, set(point_i(i),'xdata',inf,'ydata',inf); end
 end
 if length(XallB{2}) == 1,
   for i = 1:3,
     set(point_e(i),'xdata',XallB{2}*c(i) - YallB{2}*s(i),...
                    'ydata',XallB{2}*s(i) + YallB{2}*c(i));
   end
 else
   %get rid of the markers
   for i = 1:3, set(point_e(i),'xdata',inf,'ydata',inf); end
 end

 %Draw the workspace hatch
 if (hatch == 1),
   set(HRegion,'xdata',XHatchedWorkspace,'ydata',YHatchedWorkspace);
 else
  set(HRegion,'xdata',inf,'ydata',inf);
 end