%%%%%%%%% TYPE 1 SINGULARITY LOCI OF ORIENTATIONAL PARALLEL MECHANISMS %%%%%%%%
%
% This program is called by SingLociType1.m
% The program plots the workspace boundary for publishing purposes (EPS files)
%
% Last modified on June 16, 2005
% Written by Ilian A. Bonev
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

figure; Fig = gcf;
axis equal; axis off; hold on
set(gcf,'Color','white');
plot(pi*cos(frange),pi*sin(frange),'k-','LineWidth',1);
plot(0.5*pi*cos(frange),0.5*pi*sin(frange),'k-','LineWidth',1);
plot(XHatchedWorkspace,YHatchedWorkspace,...
       'color',[1,0,0],'LineStyle','none','Marker','.','MarkerSize',4);
for i = 1:3,
  s(i) = sin((i-1)*2*pi/3); c(i) = cos((i-1)*2*pi/3);
  plot(Xall{1}*c(i) - Yall{1}*s(i),Xall{1}*s(i) + Yall{1}*c(i),...
       'color',[0.5,0.5,0.5],'LineStyle','-','LineWidth',1);
  plot(XallB{1}*c(i) - YallB{1}*s(i),XallB{1}*s(i) + YallB{1}*c(i),...
       'color',[0,0,0],'LineStyle','-','LineWidth',2);
  plot(Xall{2}*c(i) - Yall{2}*s(i),Xall{2}*s(i) + Yall{2}*c(i),...
       'color',[0.5,0.5,0.5],'LineStyle','-','LineWidth',1);
  plot(XallB{2}*c(i) - YallB{2}*s(i),XallB{2}*s(i) + YallB{2}*c(i),...
       'color',[0,0,0],'LineStyle','-','LineWidth',2);
end
if length(XallB{1}) == 1,
  for i = 1:3,
    plot(XallB{1}*c(i) - YallB{1}*s(i),XallB{1}*s(i) + YallB{1}*c(i),...
     'color',[0,0,0],'LineStyle','none','Marker','.','MarkerSize',12);
  end
end
if length(XallB{2}) == 1,
  for i = 1:3,
    plot(XallB{2}*c(i) - YallB{2}*s(i),XallB{2}*s(i) + YallB{2}*c(i),...
     'color',[0,0,0],'LineStyle','none','Marker','.','MarkerSize',12);
  end
end
plot(pi*cos(frange),pi*sin(frange),'k-','LineWidth',1);
plot(-1.01*pi,0,'color',[1,1,1]);
plot(1.01*pi,0,'color',[1,1,1]);
plot(0, 1.01*pi,'color',[1,1,1]);
plot(0,-1.01*pi,'color',[1,1,1]);

[file,path] = uiputfile('*.eps','Enter the name of the EPS file', 'Figure.eps');
file_name = [path,file];
print(Fig,'-r600', '-depsc', file_name)
close(Fig)