%%%%%%%%%%%%%%%%%%% CIRCULAR MOTION WITH CONSTANT ORIENTATION %%%%%%%%%%%%%%%%%%
%                                                                              %
% Created by: Ilian Bonev                e-mail: bonev@parallemic.org          %
% Last modified: July 20, 2000                                                 %
%                                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% TRAJECTORY PARAMETERS---------------------------------------------------------
 orientation = pi/6;
 radius_circle = 100;  % radius of the circle
 s1 = 30; s2 = 100; s3 = s1;  % substeps
 num_steps = s1 + s2 + s3;  % number of defined trajectory points

% X-MOTION (Go to Circle Initial Point + Change Orientation Angle)
 for i = 1:(1+s1);
  C(:,i) = [ radius_circle*(i-1)/s1; 0];
  phi = -orientation*(i-0)/s1;
  R(:,:,i) = RotMat(phi);
 end;

% CIRCULAR MOTION WITH CONSTANT ORIENTATION ------------------------------------
 for i = (s1+1):(s1+s2);
  C(:,i) = [radius_circle*cos(2*pi*(i-s1)/s2); ...
            radius_circle*sin(2*pi*(i-s1)/s2)];
  R(:,:,i) = RotMat(phi);
 end;

% RETURN MOTION ----------------------------------------------------------------
 for i = (s1+s2+1):(s1+s2+s3);
  C(:,i) = [radius_circle - radius_circle*(i-s1-s2)/s3; 0];
  phi = -orientation + (orientation/s3)*(i-s1-s2);
  R(:,:,i) = RotMat(phi);
 end;
