%%%%%%%%%%%%%%%%%%%%%%%% INVERSE KINEMATICS SUBROUTINE %%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                              %
% Created by: Ilian Bonev                e-mail: bonev@parallemic.org          %
% Last modified: July 20, 2000                                                 %
%                                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  
% M A I N  L O O P _____________________________________________________________
 for j=1:num_steps,

% TRANSFORMATION OF PLATFORM COORDINATES----------------------------------------
 B = C(:,j)*ones(1,3) + R(:,:,j)*Bp;
 
% PLOTTING THE PLATFORM---------------------------------------------------------
 set(plat,'xdata',B(1,[1:3,1]),'ydata',B(2,[1:3,1]));

% CALCULATION OF INTERMIDIATE PARAMETERS----------------------------------------
 Ba = B - O;
 param1 = Ba(1,:).^2+Ba(2,:).^2;
 param2 = (param1+rAs-ls)/(2*rA);
 param3 = Ba(1,:).^2+Ba(2,:).^2-param2.^2;
 if any(param3<0),
   sound(2*cos(0:pi/30:10*pi));
   set(MessBox,'String','> Leg Lengths Constraint <','ForegroundColor','red');
   break;
 end;
 param4 = sqrt(param3);

% CALCULATION OF ARTICULAR COORDINATES------------------------------------------
 Theta = 2*atan((Ba(2,:)+param4)./(param2+Ba(1,:)));

% CALCULATION OF BASE JOINTS POSITIONS------------------------------------------
 A = rA*[cos(Theta); sin(Theta)] + O;
 n = (B-A)/l; %unit vectors along legs

% PLOTTING OF LINKS-------------------------------------------------------------
 set(link1p,'xdata',[O(1,1);A(1,1)],'ydata',[O(2,1);A(2,1)]);
 set(link2p,'xdata',[O(1,2);A(1,2)],'ydata',[O(2,2);A(2,2)]);
 set(link3p,'xdata',[O(1,3);A(1,3)],'ydata',[O(2,3);A(2,3)]);
 set(link1d,'xdata',[A(1,1);B(1,1)],'ydata',[A(2,1);B(2,1)]);
 set(link2d,'xdata',[A(1,2);B(1,2)],'ydata',[A(2,2);B(2,2)]);
 set(link3d,'xdata',[A(1,3);B(1,3)],'ydata',[A(2,3);B(2,3)]);

% PLOTTING OF TOOL TIP----------------------------------------------------------
 set(tooltraj,'xdata',C(1,j),'ydata',C(2,j));
 set(tooltip,'xdata',C(1,j),'ydata',C(2,j));

 drawnow
 set(MessBox,'String',OK,'ForegroundColor','black');
 end
% M A I N  L O O P _____________________________________________________________
