%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% RRR GUI %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                              %
% Created by: Ilian Bonev                e-mail: bonev@parallemic.org          %
% Last modified: July 20, 2000                                                 %
%                                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 IM = 1; %Interactive Mode is active by default
 stop = 1;

% THE MESSAGE BOX---------------------------------------------------------------
 OK = '> Admissible pose <';
 MessBox = uicontrol(fig,'Style','text','Pos',[630 250 200 16],...
   'FontWeight','demi','String',OK);
 
% THE <RUN> MENU----------------------------------------------------------------
 Run_menu = uimenu(fig,'Label','Run','Interruptible','on',...
   'CallBack',['if IM == 0,','run=1;,',...
     'while run, refresh(fig); RRR_draw; run=0; end; end;']);

% THE <REFRESH> MENU------------------------------------------------------------
 Refresh_menu = uimenu(fig,'Label','Refresh','CallBack','refresh(fig)');

% THE <TRAJECTORY> MENU---------------------------------------------------------
 Traj_menu = uimenu(fig,'Label','Trajectory');
 Traj_submenu0 = uimenu(Traj_menu,'Label','Interactive Mode',...
   'CallBack','IM = 1; refresh(fig); X = 0; Y = 0; PHI = 0; Workspace;');
 Traj_submenu1 = uimenu(Traj_menu,'Label','Trajectory 1','Separator','on');
 Traj_submenu1_rem = uimenu(Traj_submenu1,'Label',...
   'Circular Motion With Constant Orientation','CallBack',['IM = 0;,'...
   'traj_01; set(wspace,''xdata'',[],''ydata'',[]);']);
  
% THE <QUIT> MENU---------------------------------------------------------------
 Quit_menu = uimenu(fig,'Label','Quit','CallBack',['close(fig);','clear all;']);

% RESETTING THE GENERALIZED COORDINATES-----------------------------------------
 X = 0; Y = 0; PHI = 0;
 traj_00; RRR_draw; Workspace;
 
% DEFINE THE X SLIDER-----------------------------------------------------------
 sli_X = uicontrol(fig,'Style','slider','Pos',[670 150 120 17],...
   'Min',-400,'Max',400,'SliderStep',[5/800 50/800],...
   'Val',0,'CallBack',['if IM==1,','X=round(get(sli_X,''Val''));,'...
     'set(X_cur,''String'',num2str(X)),','traj_00,','RRR_draw,','end']);
 
% DEFINE THE Y SLIDER-----------------------------------------------------------
 sli_Y = uicontrol(fig,'Style','slider','Pos',[670 100 120 17],...
   'Min',-400,'Max',400,'SliderStep',[5/800 50/800],...
   'Val',0,'CallBack',['if IM==1,','Y=round(get(sli_Y,''Val''));,'...
     'set(Y_cur,''String'',num2str(Y)),','traj_00,','RRR_draw,','end']);

% DEFINE THE PHI SLIDER---------------------------------------------------------
 sli_PHI = uicontrol(fig,'Style','slider','Pos',[670 50 120 17],...
   'Min',-180,'Max',180,'SliderStep',[1/180 1/18],...
   'Val',0,'CallBack',['if IM==1,','PHI=round(get(sli_PHI,''Val''));,'...
     'set(PHI_cur,''String'',strcat(num2str(PHI),'''')),',...
     'traj_00,','RRR_draw,','Workspace,','end']);

% DEFINE THE TEXT CONTROL FOR THE MINIMUM VALUES--------------------------------
 X_min = uicontrol(fig,'Style','text','Pos',[624 150 45 17],'String','-300');
 Y_min = uicontrol(fig,'Style','text','Pos',[624 100 45 17],'String','-300');
 PHI_min = uicontrol(fig,'Style','text','Pos',[629 50 40 17],'String','-180');

% DEFINE THE TEXT CONTROL FOR THE MAXIMUM VALUES--------------------------------
 X_max = uicontrol(fig,'Style','text','Pos',[791 150 45 17],'String','+300');
 Y_max = uicontrol(fig,'Style','text','Pos',[791 100 45 17],'String','+300');
 PHI_min = uicontrol(fig,'Style','text','Pos',[791 50 40 17],'String','+180');

% DEFINE THE SLIDER LABELS------------------------------------------------------
 X_label = uicontrol(fig,'Style','text','Pos',[700 170 20 17],'String','X:');
 Y_label = uicontrol(fig,'Style','text','Pos',[700 120 20 17],'String','Y:');
 PHI_label = uicontrol(fig,'Style','text','Pos',[700 70 20 17],...
   'FontName','Symbol','String','f:');

% DEFINE THE TEXT CONTROLS FOR THE CURRENT VALUES-------------------------------
 X_cur = uicontrol(fig,'Style','text','Pos',[722 170 45 17],'String',...
   num2str(get(sli_X,'Value')));
 Y_cur = uicontrol(fig,'Style','text','Pos',[722 120 45 17],'String',...
   num2str(get(sli_Y,'Value')));
 PHI_cur = uicontrol(fig,'Style','text','Pos',[722 70 35 17],'String',...
   strcat(num2str(get(sli_PHI,'Value')),''));

% DEFINE THE RESET PUSH BUTTON--------------------------------------------------
 pbreset = uicontrol(fig,'Style','push','Pos',[701 200 60 22],...
   'String','RESET','CallBack',['if IM == 1,',...
     'set(sli_X,''Value'',0),','set(sli_Y,''Value'',0),', ...
     'set(sli_PHI,''Value'',0),',...
     'set(X_cur,''String'',''0''),','set(Y_cur,''String'',''0''),',...
     'set(PHI_cur,''String'',''0''),',...
     'X = 0; Y = 0; PHI = 0;',...
     'refresh(fig); traj_00; RRR_draw; Workspace;','end;']);
