%%%%%%%%%%%%%%% SIMULATION OF 3-RRR PLANAR PARALLEL MANIPULATORS %%%%%%%%%%%%%%%
%                                                                              %
% Created by: Ilian Bonev                e-mail: bonev@parallemic.org          %
% Last modified: July 20, 2000                                                 %
%                                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% GRAPHICS INITIALIZATION-------------------------------------------------------
 clear all;
 fig = figure('Name', '3-RRR PPM Simulation', 'NumberTitle', 'off',...
              'Position', [7,60,850,600]);
 set(gca, 'drawmode', 'fast');
 set(fig, 'MenuBar', 'none', 'BackingStore', 'off');
 subplot('Position', [0.08,0.1,0.6,0.85]);
 axis equal; axis([-400 400 -400 400]); grid;

% DEFINITION OF MANIPULATOR GEOMETRY--------------------------------------------
 rA = 170;  % length of proximal links
 rAs = rA^2;
 l = 150;  % length of distal links
 ls = l^2;
% base geometry
 O = 300*[0, -cos(pi/6),  cos(pi/6); ...
          1, -sin(pi/6), -sin(pi/6)];
% platform geometry
 Bp = 130*[0, -cos(pi/6),  cos(pi/6); ...
           1, -sin(pi/6), -sin(pi/6)];
 B = Bp;  % platform initial position
 Bo = zeros(2,3);
 A = zeros(2,3);
 plat = line('color',[.5,0,0],'erasemode','xor','LineWidth',1.3);

% DEFINITION OF TOOL------------------------------------------------------------
 C = [0; 0];
 tooltip=line('color',[0,0,0.3],'Marker','+','MarkerSize',5,'erasemode','xor');
 tooltraj=line('color',[1,0,0],'Marker','.','MarkerSize',1,'erasemode','none');
 set(tooltraj,'xdata',C(1),'ydata',C(2));
 set(tooltip,'xdata',C(1),'ydata',C(2));
        
% DRAWING OF BASE---------------------------------------------------------------
 Base01=line('color',[0,0,0.5],'Marker','o','MarkerSize',5,'erasemode','none');
 Base02=line('color',[0,0,0.5],'Marker','o','MarkerSize',5,'erasemode','none');
 Base03=line('color',[0,0,0.5],'Marker','o','MarkerSize',5,'erasemode','none');
 set(Base01,'xdata',O(1,1),'ydata',O(2,1));
 set(Base02,'xdata',O(1,2),'ydata',O(2,2));
 set(Base03,'xdata',O(1,3),'ydata',O(2,3));

% DEFINITION OF LINKS-----------------------------------------------------------
 link1p=line('color',[0,0.3,0],'LineStyle','-','erasemode','xor','LineWidth',1.5);
 link2p=line('color',[0,0.3,0],'LineStyle','-','erasemode','xor','LineWidth',1.5);
 link3p=line('color',[0,0.3,0],'LineStyle','-','erasemode','xor','LineWidth',1.5);
 link1d=line('color',[0,0.3,0],'Marker','o','MarkerSize',5, ...
	     'LineStyle','-','erasemode','xor','LineWidth',1.5);
 link2d=line('color',[0,0.3,0],'Marker','o','MarkerSize',5, ...
	     'LineStyle','-','erasemode','xor','LineWidth',1.5);
 link3d=line('color',[0,0.3,0],'Marker','o','MarkerSize',5, ...
	     'LineStyle','-','erasemode','xor','LineWidth',1.5);

% DEFINITION OF WORKSPACE-------------------------------------------------------
 wspace=line('color',[0.7,0.7,0.7],'LineStyle','-','erasemode','xor', ...
	     'LineWidth',1.5);
 
% DRAWING OF COORDINATE SYSTEM--------------------------------------------------
 X_axis=line('color','k','erasemode','none','LineWidth',1.5);
 Y_axis=line('color','k','erasemode','none','LineWidth',1.5);
 Z_axis=line('color','k','erasemode','none','LineWidth',1.5);
 set(X_axis,'xdata',[0; 50],'ydata',[0; 0]);
 set(Y_axis,'xdata',[0; 0],'ydata',[0; 50]);
 text(60,0,'X'); text(0,60,'Y');

 RRR_GUI; % runs the GUI interface
